/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class DiggerItemSpeed {
    public static final List<SpeedModifier> modifiers = new LinkedList<SpeedModifier>();

    public static void addModifier(SpeedModifier mod) {
        modifiers.add(mod);
    }

    public static Optional<Float> getModifiedSpeed(ItemStack stack, BlockState state, float initialSpeed) {
        float currentSpeed = initialSpeed;
        Optional<Float> speed = Optional.empty();
        for (SpeedModifier mod : modifiers) {
            Optional<Float> res = mod.calculateSpeed(stack, state, initialSpeed, currentSpeed);
            if (!res.isPresent()) continue;
            currentSpeed = res.get().floatValue();
            speed = res;
        }
        return speed;
    }

    @FunctionalInterface
    public static interface SpeedModifier {
        public Optional<Float> calculateSpeed(ItemStack var1, BlockState var2, float var3, float var4);
    }
}

